require 'mongo'
#require 'mongo-import'
require 'active_support/time'
require_relative '../../../watir-ruby/spec/rspec_helper'

include Mongo
#include MongoImport

module MongoUtility

  MONGO_CERT_PATH = File.dirname(__FILE__) + '/mongodb-cert.crt'

  def connectToMongoDBNOSSL(dbName)
    uri = MONGO_URL + dbName
    db = Mongo::Client.new(uri, :ssl_verify => false, :ssl_ca_cert => 'module/database/mongodb-cert.crt')
    return db
  end

  def connectToMongoDB(dbName)
    uri = MONGO_URL + dbName
    db = Mongo::Client.new(uri, :ssl_verify => true, :ssl_ca_cert => 'module/database/mongodb-cert.crt')
    return db
  end


  def connectToMongoDBVMM(dbName)
    db = Mongo::Client.new(MONGO_VMM_URI, :ssl_verify => true, :ssl_ca_cert => 'module/database/mongodb-cert.crt' )
    return db
  end

  def removeCollection(collectionName,db)
    collection = db[collectionName]
    collection.drop
  end

  def updateDocument(collectionName, objId, columnName, value, db)
    collection = db[collectionName]
    result =  collection.update_one({:_id => objId}, {"$set" => {columnName => value}})
    puts "Number of row updated " + result.n.to_s
    return result.n
  end

  def removeDocument(collectionName, objId, db)
    collection = db[collectionName]
    collection.delete_one({:_id => objId})
  end

  def insertCollection(collectionName, dbName, fileName)
    snapshot fileName, :host => 'IP      ', :port => 27017, :db => dbName, :collection => collectionName, :path => 'module/database/snapshots/'
    puts "[insertCollection] imported Collection " + collectionName
  end

  def restoreCollection(collectionName, dbName, fileName, db)
    removeCollection(collectionName, db)

    begin
      coll = db[collectionName]
      coll.insert_many(JSON.parse(File.read("module/database/snapshots/" + fileName)))

    rescue Exception=>e
      puts "[Exception insertCollection]" + e.to_s
    end

  end

  def insertDocument(collectionName, document, db)
    collection = db[collectionName]
    result = collection.insert_one(document)
    #result.n => returns 1, because 1 document was inserted.
    return result.n
  end

  def insertManyDocuments(collectionName, documents, db)
    collection = db[collectionName]

=begin
    #documents sample
    documents = [
        { :name => 'Flying Lotus' },
        { :name => 'Aphex Twin' }
      ]
=end
    result = collection.insert_many(documents)


    #result.n #=> returns 2, if 2 documents were inserted.
    return result.n

  end

  def getFieldByObjId(collectionName, objId, columnName, db)
    db[collectionName].find({:_id => objId}).each do |document|
      #=> Yields a BSON::Document.
      puts "test!!!!  ===>"  + document.to_s
      return document[columnName]
    end
  end

  def getNthCoreSettings(collectionName, objId, nth, db)
    db[collectionName].find({:_id => objId}).each do |document|
      coreSettings = document['coreSettings']
      return coreSettings[nth]
    end
  end

  def getDocumentByObjId(collectionName, objId, columnName, db)
    db[collectionName].find({:_id => objId}, :fields => [columnName]).each do |document|

      return document['coreSettings']
    end
  end

  def verifyNotificationDeleted(collectionName, objId, columnName, db)
    document = getDocumentByObjId(collectionName, objId, columnName, db)
    isDeleted = true

    for record in document
      if record[columnName] == false
        isDeleted = false
        break
      end
    end
    #puts "[verifyNotificationDeleted ] objId: " + objId + " - columnName: " + columnName + " IsDeleted: " + isDeleted.to_s
    return isDeleted

  end

  def verifyDocumentsDeleted(collectionName, objId, columnName, db)
    document =  getDocumentByObjId(collectionName, objId, columnName, db)
    isDeleted = true

    for record in document
      #puts "record[columnName] = " + record[columnName].to_s

      if record[columnName] == false
        isDeleted = false
        break
      end
    end

    return isDeleted

  end

  def retrieveThisFieldInDocumentWithMultiRows(collectionName, objId,  columnName, db)
    document = getDocumentByObjId(collectionName, objId, columnName, db)
    outPut = ""
    document.each { |record|
      #puts record[columnName]
      if record[columnName] != nil then
        outPut = record[columnName] + ',' + outPut.to_s
      else
        output = "" + "," + output.to_s
      end
    }
    #puts "outPut=" + outPut.to_s
    return outPut

  end

  def retrieveThisFieldInDocumentWithMultiRowsAsArray(collectionName, objId,  columnName, db)
    document = getDocumentByObjId(collectionName, objId, columnName, db)
    outPut = Array.new
    document.each { |record|
      if record[columnName] != nil then
        outPut.push(record[columnName])
      end
    }
    return outPut
  end

  def retrieveThisFieldInDocument(collectionName, objId,  columnName, db)
    document = getDocumentByObjId(collectionName, objId, columnName, db)

    for record in document
      puts "record[columnName]=" + record[columnName].to_s
      return record[columnName]
    end
  end

  def retreiveAllDocumentsInCollection(collectionName, db)
    documentArray = []

    db[collectionName].find().each do |document|
      documentArray << document
    end

    puts documentArray.to_s

    return documentArray
  end
end